/*
Feuer Alarm per WiFi mit ESP8266-12  mit OTA
Board: WeMos D1 & Mini
Arduino IDE 1.8.4
--------------------------------------------------------------------------
Hardware für FeuerMelderAlarm (FMA) -WLan:
ESP-07 oder 12 auf Adapterboard
mit 10k Widerstand für CH_PD zu Vcc und 10k von GPIO 15 nach GND
Zusatzhardware Mikrofonverstärker
Mic mit einem Transistor auf den Resetanschluß des ESP.
Verbindung des GPIO 14 (16) auf Reset zur Resetsperre
Jumper von GPIO 5 auf GND um DeepSleep zu umgehen.
--------------------------------------------------------------------------
1. Programmieren m1t ESP-Programmer:
Als erstes muss das Programm normal in den ESP geladen werden.
Das Prog. besteht aus dem HTTP-OTA Prog. und dem FeuerMelder(FMA)-Programm
Programmieren mit USB-Programmierer + Taster: Reset + Prog
„Prog – Button“ drücken und gedrückt halten, 
dann den „Reset-Button“ kurz betätigen und dann den „Prog-Button“ loslassen
--------------------------------------------------------------------------
2. Programmieren mit OTA
Es muss im Browser die IP-Adr. des ESP/update z.B. http://192.168.XXX.YYY/update
aufgerufen werden.
Das gesamte FMA Prog. ist als xxx.bin Datei abgelegt
C:\Users\Rainer\AppData\Local\Temp\arduino_build_xxxxxx\yyyyyyyy.ino.bin
Die richtige Datei auswählen und due Taste UPDATE betätigen.
Das neue Prog. wird geladen und der ESP neu gebootet.
--------------------------------------------------------------------------
3. ESP im Deep Sleep - neu programmieren
Es muß der Jumper (GPIO 5) gesteckt werden um nach einem Reset den DeepSleep
zu verhindern. D.h. Jumper setzen GPIO5 = GND -> dann ESP reseten.
Im Browser ESP-IP-Adr./update aufrufen --> ESP neu programmieren.
Nun testen ohne DeepSleep - falls Prog. okay - Jumper entfernen -> dann ESP-Reset
---------------------------------------------------------------------------
---------------------------------------------------------------------------
ESP-12 GPIOs:
Modul
Pin   GPIO     Beschreibung
----  ----     ------------
1     RESET    Low=Reset, hat schwachen Pull-Up Widerstand auf High
2     17       ADC Analoger Eingang 0..1V
3     CH_PD    Muss auf High gezogen werden, damit der Chip arbeitet. Low=Power Down, High=Enabled
4     16       GPIO16 Wenn mit RESET verbunden, kann ein Timer den µC aus dem Deep-Sleep aufwecken.
5     14       GPIO14 (SCK)   Normaler I/O Pin oder SPI Takt
6     12       GPIO12 (MISO)  Normaler I/O Pin oder SPI Daten
7     13       GPIO13 (MOSI)  Normaler I/O Pin oder SPI Daten
8     VCC      Spannungsversorgung 3,3V 400mA

9-14  Durch den Flash Speicher belegt, nicht verwendbar, nur beim ESP-12E und ESP-12F vorhanden.

15    GND      Masse
16    15       GPIO15 (CS) Normaler I/O Pin oder SPI Chip Select, muss beim Start auf Low gezogen werden, flackert beim Start
17    2        GPIO2 mit der blauen LED verbunden, flackert beim Start, darf beim Start nicht auf Low gezogen werden
18    0        GPIO0 Low beim Start = Firmware-Upload, muss zum normalen Start offen sein oder auf High liegen
19    4        GPIO4 Normaler I/O Pin
20    5        GPIO5 Normaler I/O Pin
21    3        RxD (GPIO3) serieller Eingang oder normaler I/O Pin
22    1        TxD (GPIO1) serieller Ausgang oder normaler I/O Pin, flackert beim Start, darf beim Start nicht auf Low gezogen werden
==============================================================================
*/

extern "C" {
#include "user_interface.h"
}

#include <ESP8266WiFi.h>
#include <WiFiClient.h>
#include <ESP8266WebServer.h>
#include <ESP8266mDNS.h>
#include <ESP8266HTTPUpdateServer.h>
#include <ESP8266HTTPClient.h>

const char* OTAhost         = "esp8266-webupdate";
const char* update_path     = "/firmware";
const char* update_username = "admin";
const char* update_password = "admin";

const char* ssid     = "RR-WLAN";
const char* password = "Speedster356Feb2012";

ESP8266WebServer        httpServer(80);
ESP8266HTTPUpdateServer httpUpdater;

byte           WiFI_connect_Cnt  = 0;
char           MsgBuffer[200];
boolean        WiFi_connected  = true;

const int      HttpPort = 80;
const char*    PHP_Server_EMail = "http://www.rainer-rebhan.de/arduino/feuer_email.php";
const char*    PHP_Server_Notif = "http://www.rainer-rebhan.de/pushover/pushme.php";

String         ESP_Infos  = "";
String         Ubatt      = "";
int            ADCValue   =  0;
int32_t        rssi       =  0;
unsigned int   ESP_BootZyklus[2];  //Bootzehler

boolean        SleepJumper = false;

#define  RST_Sperre     14     //GPIO Output = Sperre fuer den Reset-Pin
#define  Board_LED       2     //GPIO 2 = blaue LED
#define  Sleep_Sperre    5     //GPIO INPUT = Sperre für den DeepSleep über Jumper

#define  LED_EIN           LOW
#define  LED_AUS           HIGH

#define  RST_EIN           HIGH
#define  RST_AUS           LOW

ADC_MODE (ADC_VCC);        //ADC an das Stromversorgung

EspClass myESP;

HTTPClient http;

//=================================================================


void  LED_blinken_kurz(int Loop)  //kurz
{
   Loop = Loop * 10;
   for(int i=1; i < Loop; i++)
   {
      digitalWrite(Board_LED, LED_EIN);
      delay(10);
      digitalWrite(Board_LED, LED_AUS);
      delay(40);
   }
}


void  LED_blinken_lang(int Loop)  //lang
{
   Loop = Loop * 7;
   for(int i=1; i < Loop; i++)
   {
      digitalWrite(Board_LED, LED_EIN);
      delay(50);
      digitalWrite(Board_LED, LED_AUS);
      delay(500);
   }
}


void  LED_blinken_kkl(int Loop)   //kurz-kurz-lang
{
   Loop = Loop * 7;
   for(int i=1; i < Loop; i++)
   {
      digitalWrite(Board_LED, LED_EIN);
      delay(10);
      digitalWrite(Board_LED, LED_AUS);
      delay(150);
      digitalWrite(Board_LED, LED_EIN);
      delay(10);
      digitalWrite(Board_LED, LED_AUS);
      delay(800);      
   }
}


//--------------------------------------------------------------------
void HTTP_Post_Request_Notif()
{
   String PushMsg = "&pushinfo=";
   String message = PushMsg + "FeuerMelder Alarm\n\r" + ESP_Infos;
   message.toCharArray(MsgBuffer,190);
   Serial.println(MsgBuffer);
   http.begin(PHP_Server_Notif);
   http.addHeader("Content-Type", "application/x-www-form-urlencoded; charset=UTF-8");
   int httpCode = http.POST(MsgBuffer);
   if(httpCode > 0)
   {
      Serial.printf("HTTP-POST (Notif) Code: %d\n", httpCode);
      if(httpCode == HTTP_CODE_OK)
      {
            String response = http.getString();
            Serial.println(response);
      }else{Serial.println("Seite nicht gefunden");} //myESP01.deepSleep(0, WAKE_RFCAL);
    }else{
      Serial.printf("POST(Notif)...failed, error: %s\n", http.errorToString(httpCode).c_str());
      WiFi.forceSleepBegin();                    // Wlan aus
      LED_blinken_kurz(3);
      WiFi.forceSleepWake();                     // Wlan ein
    }
    http.end();   
}


//--------------------------------------------------------------------
void HTTP_Post_Request_eMail()
{
   String PostMsg =  "&feuer=";
   String message = PostMsg + "<b>Feuer-Melder Alarm vom ESP8266-01</b>\n\r" + ESP_Infos;
   message.toCharArray(MsgBuffer,190);
   Serial.println(MsgBuffer);
   http.begin(PHP_Server_EMail);
   http.addHeader("Content-Type", "application/x-www-form-urlencoded; charset=UTF-8");
   int httpCode = http.POST(MsgBuffer);
   if(httpCode > 0)
   {
      Serial.printf("HTTP-POST (eMail) Code: %d\n", httpCode);
      if(httpCode == HTTP_CODE_OK)
      {
            String response = http.getString();
            Serial.println(response);
      }else{Serial.println("Seite nicht gefunden");}
    }else{
      Serial.printf("POST(eMail)...failed, error: %s\n", http.errorToString(httpCode).c_str());
      WiFi.forceSleepBegin();                    // Wlan aus
      LED_blinken_kurz(3);
      WiFi.forceSleepWake();                     // Wlan ein
    }
    http.end();   
}


//---------------------------------------------------------------

void setup(void)
{
   Serial.begin(57600);
   delay(50);
   Serial.println("\n\r\nWiFi-Feuermelder mit OTA");
   WiFi.mode(WIFI_AP_STA);
   WiFi_connected = true;
  
   pinMode(Board_LED, OUTPUT);
   digitalWrite(Board_LED, LED_AUS);

   pinMode(RST_Sperre, INPUT);

   pinMode(Sleep_Sperre, INPUT_PULLUP);
   SleepJumper = digitalRead(Sleep_Sperre);

   //Serial.print("OTA-Uploader Booting...");

   const rst_info * resetInfo = system_get_rst_info();                      // Reset Reason einlesen
   myESP.rtcUserMemoryRead(0, ESP_BootZyklus, sizeof(ESP_BootZyklus));      // Boot Nummer aus RTC-Ram lesen
   if ((resetInfo->reason) == 6)ESP_BootZyklus[0] = 0;                      // #6: BootZyk=0  #5: zählen
   ESP_BootZyklus[0]++;                                      
   myESP.rtcUserMemoryWrite(0, ESP_BootZyklus, sizeof(ESP_BootZyklus));     // Boot Nummer im RTC-Ram speichern

   ADCValue = myESP.getVcc() + 110;                                         // Batteriespannung Korrektur Wert
   float ADCfloat = float(ADCValue);
   Ubatt = String(ADCfloat / 1000, 2) + " V";

   WiFi.begin(ssid, password);
  
   while(WiFi.waitForConnectResult() != WL_CONNECTED)
   {
      WiFi.begin(ssid, password);
      //Serial.println("kein WiFi - STOP");
      WiFi_connected = false;
      LED_blinken_kkl(2);
   }

   if (WiFi_connected)
   {  
      LED_blinken_kurz(1);
      pinMode(RST_Sperre, OUTPUT);
      digitalWrite(RST_Sperre, RST_EIN);
      
      //Serial.println("WiFi okay");
      rssi = wifi_station_get_rssi();
      ESP_Infos = "UBatt=" + Ubatt + "  BootNr=" + String(ESP_BootZyklus[0])+ "  Signal=" + String(rssi) + "dBm\n\r";
      Serial.println(ESP_Infos);

      MDNS.begin(OTAhost);

      httpUpdater.setup(&httpServer);
      httpServer.begin();

      MDNS.addService("http", "tcp", 80);

      /*
      Serial.println("HTTP-Update-Server ready!");
      Serial.print("Upload ueber Browser (IP) ");
      Serial.print(WiFi.localIP());
      Serial.println("/update");
      Serial.println("Upload Bin-Datei: C:/Users/Rainer/AppData/Local/Temp/arduino_build__xxx/xxx.ino.bin");
      Serial.print("\n\rSleep-Jumper: ");
      */
      
      //if(SleepJumper){Serial.println("EIN");}else{Serial.println("AUS");}
      
      //Sleep-Jumper setzen - dann resetten um DeepSleep und Requests zu verhindern
      //ohne SleepJumper = true;      Test: SleepJumper = false; oder false;

      if(SleepJumper)
      {
         LED_blinken_kurz(1);
         //Serial.println("eMail-Request");
         HTTP_Post_Request_eMail();
         LED_blinken_kurz(1);
         //Serial.println("Notif-Request");
         HTTP_Post_Request_Notif();
         WiFi.forceSleepBegin();                    // Wlan aus
         LED_blinken_lang(10);
         WiFi.forceSleepWake();                     // Wlan ein
         //Serial.println("\nDeep-Sleep");
         digitalWrite(Board_LED,  LED_AUS);
         pinMode(RST_Sperre, INPUT);
         delay(100);
         myESP.deepSleep(0, WAKE_RFCAL);
      }else{
         //Sleep Jumper nicht gesetzt
         LED_blinken_kkl(1);
      }
   }

   digitalWrite(Board_LED,  LED_AUS);
   pinMode(RST_Sperre, INPUT);
}

//--------------------------------------------------------

void loop(void)
{
  httpServer.handleClient();
}
